# metaplay-gameserver

## 0.9.1 (2026-02-04)

### Bug Fixes

* Fixed Grafana dashboards not created with Helm 3.19.5+.

## 0.9.0 (2025-08-18)

### Features

* Added `admin.stackAuthEnabled` feature flag to allow disabling liveops dashboard ingress authentication.
* Added `infraMigration` feature flag to allow deactivating components which are going to be managed by the infrastructure.
* Added extra tests for ensuring that game server image repository and tag have proper values.
* Bumped metaplay-server Grafana dashboard to v0.3.2.
* Removed legacy helper function of `expanded-shard-config`.

### Bug Fixes

* Fixed legacy JSON schema which is no longer valid against the [jsonschema validator](https://github.com/helm/helm/commit/cb8595bc650e2ec7459427d2b0430599431a3dbe) introduced in Helm v3.18.5.

## 0.8.0 (2025-04-02)

> [!CAUTION]
> This chart version requires Metaplay SDK R32 or later and infra-modules `v0.8.0` or later to function.

### Breaking changes

* Deprecated legacy operator and CRDs and promoted `gameservers.metaplay.io/v0` API to production. This chart requires infra-modules `v0.8.0` or later to function properly.
* Enabled new PublicWebApi functionality by default. This replaces the legacy public web endpoints and requires a Metaplay R32 based game server or later and infra-modules `v0.8.0` or later.
* The `auth` block from the `values.yaml` has been removed. For self-hosted stacks, the configuration is done via Terraform now. Metaplay managed servers only support using Metaplay Auth.
* Removed `admin.auth` block from the `values.yaml`. Authentication is now handled by StackAPI.

### Features

* Allow more characters for display names of deployments. Remove the default name.

### Bug Fixes

* Ensure tag is treated as string with `GameServer` custom resources.

## 0.7.1 (2025-02-01)

### Features

* Added support for publicWebApi.
* Added support for managing Grafana through grafana-operator custom resources.
* Moved Ingress auth checks against internal services to avoid having to traverse an extra Ingress for every authentication check by directly talking to EAS.

### Bug Fixes

* Fixed failure when not able to discover OAuth2 details from infrastructure.

## 0.7.0 (2024-12-05)

### Breaking Changes

* Force-enable health probe proxying via the Go entrypoint instead of the game server's own 8888 port. This change was introduced in Metaplay SDK Release 28 and earlier SDK versions will no longer work with this chart. This change removes the `experimental.useHealthProbeProxy` value and makes it the default behavior.

### Features

* Added extra checks when `.rbac.serviceAccount.create` is enabled to see that a service account does not already exist.
* Bump metaplay-server dashboard version to 0.3.0. This introduces additional graphs about in-memory game config cache, which are added in Metaplay SDK Release 31 and relate to game config experiment specializations.
* Reduced the set of permissions for the Role when `.rbac.role.create` is enabled.

## v0.6.3 (2024-08-23)

### Added

* Added public ingress for the admin route `/.well-known/` to the game server.

### Changed

* Bumped the Grafana Helm chart version to 7.0.4.
* Bumped the metaplay-server Grafana dashboard version to v0.2.7.

## v0.6.2 (2024-08-09)

* Added new configuration block `rbac.role` which allows creating `Role` and `RoleBinding` in tenant namespace. This configuration is tentatively used for multi-region support, however, the intra-cluster RBAC is reserved for future usage as well.
* Fixed game runtime options port generation to deduplicate list of game server and web socket ports.

## v0.6.1 (2024-06-12)

### Added

* New boolean option `experimental.useHealthProbeProxy` that directs the Kubernetes health probes to be routed via a proxy in the `entrypoint` binary. This allows bypassing the health probes temporarily when taking heap dumps of the game server process to avoid the process being terminated as the Kubernetes liveness probes fail during the operation. (Requires SDK Release 29 to work.)

### Fixed

* For OAuth2 sessions, include userinfo in the sessions that were started by visiting Grafana. Previously, this caused the session state to not have the userinfo, which then caused a 500 Internal Server Error when visiting the dashboard, which requires userinfo to be present.

## v0.6.0 (2024-05-28)

* Added `experimental.gameserversV0Api.enabled` to allow toggling the game server to use the new GameServer resources. Useful primarily for multi-region deployments at present.
* Added `grafana.createConfigmap` which allows customizing grafana ConfigMap in tenant namespaces when set to false (default value). This fixed both issues of grafana url being localhost if no `config.extraEnv.Metaplay_Deployment__GrafanaUri` is given, and Grafana dashboards being missing in tenant namespace. Please note that this change will trigger a new Grafana deployment in the tenant namespace the next time a game server deployment happens.
* Removed support for `experimental.operatorV2Enabled` based on resources.
* Removed support for `experimental.udp` for UDP endpoints.
* Removed support for in-chart Loki (i.e. `loki` values block).
* Removed support for in-chart Prometheus (i.e. `prometheus` values block).
* Removed support for in-chart sidecar logging via fluent-bit (i.e. `logging` values block).
* Simplify HTTP routing to admin api to not require an Authorization header for requests. The game server checks the permissions anyway so the admin ingress does not need to do that.
* For OAuth2 and Github, fetch the OAuth2 userinfo every 30 seconds and pass it to the game server as `Metaplay-Userinfo` header to enable using it for role checks in the game server.
* Switch to game server HTTP port 8080 to allow the container to use a non-root user.
* Fix logout redirect uri when using `tenant` authentication (developer portal).
* Allow SDK version to be passed in with `--set-string sdk.version=x.y.z`.
* Create a temporary volume for writing core dumps into in case of hard server crashes. The volume is persisted as long as the pod is alive and survives container restarts but is cleared when the pod is removed (e.g., in the case of a new deployment or a node shutdown).
* Fixed game server dualstack LoadBalancer when infrastructure uses aws-load-balancer-controller. In this case the correct dualstack annotation is also set for the LoadBalancer Service.
* Fixed the dashboard and Grafana to share the same session when accessing from the browser.

## v0.5.3 (2024-04-08)

* Updated default shard configuration's singleton setup to use 250m and 500Mi of CPU and memory by default to give a more realistic baseline resource request to start with.

## v0.5.2 (2024-02-20)

* Changed `admin.enabled` and `grafana.enabled` to be `true` by default. If you wish to not have the chart provision either, please explicitly opt out of them by setting them `false`.

## v0.5.1 (2023-12-21)

* Added `securityContext.sysctls` passthrough for tweaking kernel parameters.
* Added additional default annotation to UdpService to ensure cross-AZ load balancing is set up.
* Added support for `public` boolean for shard configs. Disabled by default, enabling it will set the specific shard up with additional annotations, tolerations, and nodeSelectors to target the shards in public subnets as well as providing the public IP as a value to the pod.
* Added `adminApi`, and `connection` booleans for shard configs. These are used for targeting traffic from Services to the right Pods and have the same functionality as when using the older `entityKinds` parameter and setting the `AdminApi` and `Connection` entities. This change is made to pave the way for deprecating entity kind configurations via the Helm chart.
* Added support for `podAnnotations`, `podLabels`, `podNodeSelector`, `podTolerations`, `podAffinity`, `podPorts` and `podEnv` for shard configs. These can be used to adjust corresponding values but only for the specific shard types. The formats of the objects are identical to those of the corresponding Pod spec objects.

## v0.5.0 (2023-11-09)

* Breaking change: Externally facing load balancers are now tagged with `service.beta.kubernetes.io/aws-load-balancer-type` value `external` and thus handled by `aws-load-balancer-controller`. *This chart version requires Metaplay infrastructure v0.2.9 or later to work.*
* Added a double-check for no-auth server deployment. Now it's possible to deploy a server without authentication only if set `.auth.enabled=false` and `.auth.skipAuthAlways=true`, otherwise the deployment will fail.
* Added `nodeSelector`, `tolerations`, `affinity`, and `hostNetwork` passthroughs to the chart. These control the corresponding values for the game server StatefulSet.
* Added `.auth.eas.annotations` which supports passing extra annotations to customize the external-auth-server.
* Updated Grafana chart to 7.0.3 (app version 10.1.5).
* Updated external-auth-server to v0.13.3 and moved to use `EAS_ALLOW_PLAIN_SERVER_SIDE_TOKEN` to allow easier and simplified external-auth-server setup. Made config token setup more robust.

## v0.4.7 (2023-08-23)

* Removed Metaplay Logs Grafana dashboard as deprecated. You should be using Grafana's Explore section with LogQL queries for more powerful querying of logs.
* Added WebSocket tests for `helm test` when WebSockets are enabled for the game server.
* Added `None` as the value of `AdminApi.Type` when auth is disabled, in which case free access to the admin dashboard is allowed and an e2e test can start.
* Fixed `grafana-uri` helper to correctly use `Metaplay_Deployment__GrafanaUri` env var to discover Grafana URL as opposed to legacy env var.
* Updated Grafana chart to 6.58.9 (app version 10.0.3).

## v0.4.6 (2023-05-22)

* Updated Grafana chart to 6.56.1 (app version 9.5.1).
* Added deprecation notices informing of `loki.enabled`, `prometheus.enabled`, `logging.file.enabled` and `logging.fluentbit.enabled` deprecations in upcoming 0.5.0 chart version.

## v0.4.5 (2023-03-14)

* Updated Grafana dashboards to be pulled from `https://dashboards.metaplay.dev/`.
* Deprecated `.experimental.legacyAuth.enabled` Helm value. This switch has only been used with pre-R19 game servers and newer chart versions, so if you are running an R19 game server and later with chart version 0.4.0 or later, this upcoming change will not impact you.
* Added extra section to `NOTES.txt` on how to get logs from the server shards.
* Updated Grafana chart to 6.38.6 (app version 9.1.5).
* Changed admin and external-auth-server Ingresses to enable CORS and apply a very permissive `Access-Control-Allow-Origin` setup as test for fixing CORS issues.

## v0.4.4 (2022-12-15)

* Added experimental UDP endpoint support through `experimental.udp`. See `values.yaml` for example. Requires infrastructure to have metaplay-operator v0.1.5 or later deployed along with `UdpService` CRDs.

## v0.4.3 (2022-11-11)

* Fixed rendering of custom external-auth-server tokens.

## v0.4.2 (2022-10-14)

* Added `experimental.websockets` block to allow controlling websockets for the game server. Setting the `enabled` parameter true configures the game server to listen in on the default 9380 port for websocket connections. Using the `ports` list allows overriding the port configurations. The format of the `ports` block follows that of `service.ports`.

## v0.4.1 (2022-06-22)

* Updated Prometheus chart to 15.9.2 (app version 2.34.0).
* Updated Grafana chart to 6.29.6 (app version 8.5.3).

## v0.4.0

* Breaking change: By default the chart will use the new Metaplay R19 compliant configurations for authentication options. If you wish to use this chart with pre-R19 game servers, you can set `experimental.legacyAuth.enabled: false` and `admin.auth.dashboard: false` (latter is only needed in Auth0 use cases where the game server dashboard is expected to be the only location where the authentication flow is handled).
* Added mandatory `environmentFamily` Helm value, which is required by R19 game servers and is used to guide the game server about the default values for different environments. Accepted values are `Development`, `Staging`, and `Production`.
* Added support for `github` `auth.type`. More information about this is available in the chart README.
* Added a chart game server options checksum annotation to the game server. This will ensure that the game server is restarted if the chart-based game server options are changed.
* Added `auth.tokens` dictionary to allow customizing which external-auth-server tokens should be used for which ingress endpoint. If not provided, sane defaults will be determined based on value of `auth.type`. More details on using this setup are available in the README.
* Added `experimental.infraPrometheus.enabled` flag, which allows configuring the chart's Grafana to use a Prometheus proxy defined at `experimental.infraPrometheus.secretName`. These require a multi-tenant and Cortex enabled Metaplay infrastructure stack to work (minimum version of v0.2.1 infra-modules/environments/aws-region).
* Allowed deploying metaplay-operator v2's CRs.

## v0.3.2

* Updated Prometheus chart to 15.8.0 (app version 2.34.0).
* Added additional `Metaplay-IdToken` and `Metaplay-AccessToken` headers to be sent to the game server LiveOps Dashboard when using Auth0 authentication. These are needed for shifting user authentication from game server to the reverse proxy perimeter auth server.
* Set prometheus deployment's update strategy to be `Recreate` to avoid PVC conflict when updating.
* Updated Grafana chart to 6.25.1 (app version 8.4.2).
* Updated Loki chart to 2.10.3 (app version 2.4.2).

## v0.3.1

* Added `DeploymentOptions.AdminUri` and `DeploymentOptions.ApiUri` to be set as a game server runtime option if admin is enabled.
* Updated Grafana chart to 6.21.4 (app version 8.3.5).
* Updated Loki chart to 2.9.1 (app version 2.4.2).
* Added `experimental.infraLoki.enabled` value. Enabling this will configure the game server Grafana to leverage the Loki provided by the underlying infrastructure stack. Requires `infra-modules` `v0.1.8` or later to function.
* Fixed external-auth-server default secret value generation to not contain illegal characters.
* Changed admin Ingress. By default if authentication is enabled, the game server API will be protected by external-auth-server and the authentication configurations, while admin dashboard SPA assets are not (this is due to issues with dashboard and perimeter authentication logic conflicts). This behavior can be tweaked with `admin.auth.dashboard` and `admin.auth.api` boolean values.
* Fixing broken public endpoint ingress setup.

## v0.3.0

* Updated Ingress resources from `networking.k8s.io/v1beta1` to `networking.k8s.io/v1`.
* Updated RBAC resources from `rbac.authorization.k8s.io/v1beta1` to `rbac.authorization.k8s.io/v1`.
* Moved `experimental.gameserverIpv6Enabled` parameter to `service.ipv6Enabled` and set to true by default.
* Moved `experimental.publicApiEndpoints` block to `publicApiEndpoints`. The format of the block is the same as before.
* Added initial `values.schema.json` to validate Helm chart input values.
* Added warnings to `NOTES.txt` if deploying critical services without authentication enabled.
* Added `hostname` value (can be e.g. `idler-develop.p1.metaplay.io`). If `admin.hostname` and `service.hostname` are not being provided, `hostname` will be used to infer sane default names for different endpoints.
* Updated resources with standardized set of common labels to be used (these include `app.kubernetes.io/name`, `app.kubernetes.io/managed-by`, `app.kubernetes.io/instance`, and `helm.sh/chart`).
* Added new `auth` value object. This object can be used to configure Auth0 or more general OIDC authentication setups. When using it to configure Auth0 authentication, these values will be configured across all relevant chart-managed resources (e.g. LiveOps dashboard, Grafana, etc.) and will now not require duplicating same information across multiple configuration blocks. This change deprecates the `admin.auth` block.
* Replaced oauth2-proxy with external-auth-server to provide authentication services to Ingress. external-auth-server configurations are found under `auth.eas`, but the defaults should work for most of the cases.
* Deprecated and removed `externalDns` configuration block. From now external-dns is required to be present on the cluster into which the chart is being deployed.
* Deprecated and removed `api` configuration block. From now on machine users interacting with the game server API must use the same game server admin Ingress as the LiveOps dashboard users.
* AWS NLB are the only allowed game server service load balancer type permitted anymore. This aligns with AWS's move to deprecate classic load balancers.
* Updated Loki chart to version 2.8.1 (app version 2.4.1).
* Updated Grafana chart to version 6.18.2 (app version 8.3.1).
* Updated fluent-bit to 1.8.10.
* Added `debug.headerEcho` flag. Enabling the flag will deploy `gameserver-admin.fqdn/echo` and `gameserver-admin.fqdn/grafana/echo` (if `grafana.enabled` is set) endpoints, which can be useful in debugging e.g. authentication and other dashboard header issues.
* Split LiveOps Dashboard ingress and observability stack (Grafana) ingress into two Ingress resources to allow for different handling of authentication-related header passthroughs.
* Changed `.Values.service.tls.enabled` and `.Values.admin.tls.enabled` to be `true` by default.
* Added a helper to attempt to discover TLS certificate details from Kubernetes in the event that `.Values.service.tls.sslCertArn` or `.Values.admin.tls.sslCertArn` are not explicitly given.

## v0.2.3

* Updated Loki to chart version 2.6.0 (app version 2.3.0).
* Updated Prometheus chart to 14.2.0 (app version 2.26.0).
* Updated Grafana chart to 6.15.0 (app version 8.1.0).
* Updated fluent-bit to 1.8.7.
* Removed fluentd. Going forward if fluent-bit is enabled, it will send logs directly to Loki without relaying through fluentd.

## v0.2.2

* Added `experimental.publicApiEndpoints` parameter for exposing additional HTTP endpoints from game servers. Please check out the README for details on usage.
* Added `app` and `gameserver` labels to chart test pods to ease log finding.

## v0.2.1

* Breaking! `experimental.gameServerIpv6Enabled` parameter will be moved to `service.ipv6.enabled` and will be enabled by default.
* Added `pullPolicy` parameters to all chart `image` parameters. These allow overriding the image pull policies for e.g. game server and other images (for example in dev environments where image tags might be re-used, it may be beneficial to set the value ot `Always`). Default value is `IfNotPresent`.
* Added `api.annotations` to allow passing annotations to the API Ingress resource.

## v0.2.0

* Breaking! Deprecate old server runtime configs and move to supporting new YAML-based runtime options. Requires Metaplay R10 or later to function.
* Breaking! `experimental.metaplayOperator` parameter is removed and deployment of this chart will rely on the metaplay.io/v1 GameServer CRD. This removes support for deploying game servers using the Kubernetes native StatefulSet resources.
* Breaking! `experimental.healthzProbeEndpoints` parameter is removed socket-based readiness and liveness probes will be fully deprecated in favor of /isReady and /healthz HTTP endpoint checks.
* Deprecated support for Sqlite using the `database.backend` option. From now on the value is forced to be MySql.
* Added game server endpoint and admin health tests (can be used with `helm test`) for checking deployment status.
* Removed db-access secret test as db-access secret is no longer being used for anything.
* Changed game server admin service to be always deployed with chart. Ingress is still only deployed if `admin.enabled` value is set.

## v0.1.5

* BREAKING CHANGE: The default for `.config.secretKeyName` has been changed to `metaplay-infra-options.yaml`. This requires at least infra-modules v0.1.2 or later and Metaplay SDK R10 or later to function. If you are running an earlier combination, you will have to provide the old value of `metaplay-config.json` via `.config.secretKeyName` Helm value.
* Added support for NLB IPv6 support with `experimental.gameServerIpv6Enabled`. Requires `service.loadbalancerType` to be `nlb` and requires metaplay-operator v0.0.5 or later (shipped with infra-modules v0.1.2 and later).
* Added passthroughs of game server environment variables in new format (e.g. `METAPLAY_DATABASEBACKEND` to `Metaplay_Database__Backend`). Old legacy environment variables will continue to provided until metaplay-gameserver chart v0.2.0.
* Changed `externalTrafficPolicy` default to `Local` (was `Cluster` earlier) for game server client Service resource.
* Added support for YAML configuration files and the new Metaplay R10 configuration system. Giving files ending with `.yaml` in `.config.files` list will hand those files over to the new configuration file system.
* Added `Deployment.ChartVersion` option passing to game servers via environment variables. This contains the chart version of the metaplay-gameserver chart that is being used and the game server can visualize and carry out compatibility checks with this, if needed.
* Added `Deployment.GrafanaUri` and `Deployment.KubernetesNamespace` option passing.

## v0.1.4

* Updating metaplay-jwt-auth default image to v0.0.4 to add support for token signed with static internal keys.
* Updated README with further details on using Auth0 with game servers.

## v0.1.3

* BREAKING CHANGE: Enabling `rbac.serviceAccount.enabled` by default. This will require infra-modules v0.1.1 or later to be deployed.
* Updated README with examples on Loki log persistence
* Updated Grafana and Prometheus upstream repository references away from deprecated chart repos

## v0.1.2

* Added METAPLAY\_KUBERNETESNAMESPACE environment variable to all game server pods
* Added METAPLAY\_GRAFANAURL environment variable to all game server pods if Grafana is enabled (will intelligently figure out the URL from other values). The URL can be overridden by providing the environment variable through `config.extraEnv` list.

## v0.1.1

* Added support for pod service accounts to game server shards. Defaults to assuming availability of `gameserver` service account in the same namespace (infra-modules v0.1.1 provisions such service accounts). Service account can also be created using the `rbac.serviceAccount.create` flag. Usage of RBAC for game server pods is deactivated by default.
* Fixed `logging.file.type` handling for fluentbit configs

## v0.1.0

* BREAKING CHANGE: .Values.experimental.metaplayOperator and .Values.experimental.healthzProbeEndpoints have been turned on by default. They can still be manually turned off with values to enable earlier behavior. In v0.2.0 and onwards these options will always be enabled and legacy behavior will be deprecated fully.
* Remove dependency on `db-access` secret. Assume database configurations to be provided either through the metaplay-config.json file or through extra environment variables.

## v0.0.14

* BREAKING CHANGE: Switch to using .Values.service.ports list to define externally visible ports. Deprecates .Values.service.port. If you have not explicitly defined .Values.service.port before, then everything will continue as is.
* Added support for .Values.service.ports targetPort configuration; assuming an empty target port to equal 9339
* Added support for defining list of exposed ports for the container to be the set of all targetPort configurations for .Values.server.ports
* Added METAPLAY\_CLIENTPORTS environment variable to server shards, which is composed of all the targetPorts in .Values.service.ports.

## v0.0.13

* Experimental Metaplay GameServer resources with `experimental.metaplayOperator` switch.
* Changed shards to share a single fluent-bit configuration (previously all shard types had their own specific fluent-bit configuration).
* Expose port 8888 from gameserver pods via headless service.
* Change gameserver liveness probe to be more lenient to avoid false positives when server under stress.
* Switch to using :8888/isReady for readiness probe (when .experimental.healthzProbeEndpoints is enabled).

## v0.0.12

* Experimental liveness and readiness probes with `experimental.healthzProbeEndpoints` (BREAKING: Changed liveness and readiness probes to poll :8888/healthz)
* Added `service.externalTrafficPolicy` parameter for game server load balancer
* Disabled CLR Threadpool spinlock as it was not performing well.
* Tweaked liveness and readiness probe values
* Default config file to ./Config/Config.base.json
* Updated oauth2-proxy to v6.0.0

## v0.0.11

* [INF-58] Fixed API JWT authentication to use proper Docker images
* [INF-61] Switch gameserver shards to follow strict anti-affinity when in dedicated node mode
* [INF-62] Add additional annotations to shard StatefulSet to capture changes in shard configs
* [INF-63] Add ClusterCookie to shards

## v0.0.10

* Increased fluent-bit tail input max buffer size to 5MB
* Added switch to enable metrics endpoint for fluent-bit

## v0.0.9

* [INF-36] Added support for custom fluentd outputs through `logging.fluentd.additionalStores`
* [INF-39] Configure shard StatefulSets to all redeploy when any shard configuration changes (will allow reloading of cluster)

## v0.0.8

* Added shard pod anti-affinity
* Added support for toggling game load balancers to NLBs (optional)
* Added support for namespaced Prometheus deployment
* Added support for namespaced Loki deployment
* Added support for namespaced Grafana deployment with integration of local Prometheus and Loki data sources
* Added support for namespaced fluentd deployment
* Added support for toggling local fluent-bit sidecar logging of game server
* Added `config.extraEnv` value parameter to allow for passing additional environment variables to game server shards
* Added `config.files` value parameter to allow passing of one or more explicit server configuration files
* Updated metaplay-jwt-auth to v0.0.3 to fix issue with rotating upstream JWKS keys

## v0.0.7

* Added NOTES.txt to provide information on deployment
* Added `shardCount` annotation to shard StatefulSets to force StatefulSet to be entirely redeployed on replica count changes
* Change to require api.hostname to be set if api.enabled is true
* Fixed selector for admin service with sharded setup

## v0.0.6

* Fixed metaplay-jwt-auth not getting reloaded with config change

## v0.0.5

* Changed gameserver API configurations and authentication to metaplay-jwt-auth
* Fixed some bugs with TLS being enabled but cert ARN not being given failing deployment; now fall back to non-TLS gracefully

## v0.0.4

* Added oauth2-proxy support for protecting admin ingress
* Added option to enable gameserver API ingress

## v0.0.3

* Added support for `metaplay-config` secret

## v0.0.2

* Added LoadBalancer
* Added support for external-dns annotations
* Added support for enabling external admin interface
* Added support for `service.port` parameter

## v0.0.1

* Initial version
